<?php
// Lancer la session avant tout
session_start();

// Charger la configuration
require_once __DIR__ . '/app/config/config.php';

// Charger manuellement le routeur (core)
require_once APP_ROOT . '/core/Router.php';

// Charger les contrôleurs dynamiquement
spl_autoload_register(function ($class) {
    $controllerPath = APP_ROOT . '/controllers/' . $class . '.php';
    if (file_exists($controllerPath)) {
        require_once $controllerPath;
    }
});

// Créer une instance du routeur
$router = new Router();

// Routes publiques
$router->get('/', 'HomeController@index');
$router->get('/home', 'HomeController@index');
$router->get('/about', 'HomeController@about');
$router->get('/contact', 'HomeController@contact');
$router->post('/contact', 'HomeController@contact');
$router->get('/faq', 'HomeController@faq');

// Authentification
$router->get('/auth/login', 'AuthController@login');
$router->post('/auth/login', 'AuthController@login');
$router->get('/auth/register', 'AuthController@register');
$router->post('/auth/register', 'AuthController@register');
$router->get('/auth/logout', 'AuthController@logout');
$router->get('/auth/profile', 'AuthController@profile');
$router->post('/auth/profile', 'AuthController@profile');

// Diagnostic
$router->get('/diagnostic', 'DiagnosticController@index');
$router->post('/diagnostic/analyze', 'DiagnosticController@analyze');
$router->get('/diagnostic/results', 'DiagnosticController@results');
$router->get('/diagnostic/history', 'DiagnosticController@history');
$router->get('/diagnostic/details/{id}', 'DiagnosticController@details');
$router->get('/diagnostic/search', 'DiagnosticController@search');

// Administration
$router->get('/admin', 'AdminController@index');
$router->get('/admin/diseases', 'AdminController@diseases');
$router->post('/admin/diseases', 'AdminController@diseases');
$router->get('/admin/symptoms', 'AdminController@symptoms');
$router->post('/admin/symptoms', 'AdminController@symptoms');
$router->get('/admin/relations', 'AdminController@relations');
$router->post('/admin/relations', 'AdminController@relations');

// Démarrer le routeur
$router->dispatch();
