<div class="hero">
    <h1><?= APP_NAME ?></h1>
    <p class="lead">Bienvenue sur notre plateforme de diagnostic médical intelligent. Identifiez rapidement les maladies potentielles en fonction de vos symptômes.</p>
    <hr>
    <p>Notre système utilise des algorithmes avancés pour analyser vos symptômes et vous fournir des informations pertinentes sur les maladies potentielles. Consultez toujours un professionnel de santé pour un diagnostic définitif.</p>
    <a class="btn" href="<?= APP_URL ?>/diagnostic">
        <i class="fas fa-stethoscope"></i>Commencer un diagnostic
    </a>
</div>

<div class="features">
    <div class="feature-card">
        <div class="card-content">
            <i class="fas fa-search"></i>
            <h5>Analyse des symptômes</h5>
            <p>Sélectionnez vos symptômes et notre système les analysera pour identifier les maladies potentielles.</p>
        </div>
    </div>
    <div class="feature-card">
        <div class="card-content">
            <i class="fas fa-history"></i>
            <h5>Historique des diagnostics</h5>
            <p>Consultez l'historique de vos diagnostics et suivez l'évolution de votre santé dans le temps.</p>
        </div>
    </div>
    <div class="feature-card">
        <div class="card-content">
            <i class="fas fa-user-md"></i>
            <h5>Conseils personnalisés</h5>
            <p>Recevez des recommandations adaptées à votre situation, basées sur l'analyse de vos symptômes.</p>
        </div>
    </div>
</div>

<div class="info-sections">
    <div class="info-card">
        <div class="card-header">
            <h5><i class="fas fa-question-circle"></i>Comment ça marche ?</h5>
        </div>
        <div class="card-body">
            <ol>
                <li>Créez un compte ou connectez-vous à votre compte existant.</li>
                <li>Accédez à la page de diagnostic et sélectionnez les symptômes que vous ressentez.</li>
                <li>Notre système analyse vos symptômes et identifie les maladies potentielles.</li>
                <li>Consultez les résultats et les recommandations personnalisées.</li>
                <li>Partagez les résultats avec votre médecin pour un diagnostic définitif.</li>
            </ol>
        </div>
    </div>
    <div class="info-card">
        <div class="card-header">
            <h5><i class="fas fa-info-circle"></i>À propos de notre système</h5>
        </div>
        <div class="card-body">
            <p>Notre système de diagnostic médical utilise une base de données complète de maladies et de symptômes, ainsi que des algorithmes avancés pour fournir des résultats précis.</p>
            <p>Nous travaillons en collaboration avec des professionnels de la santé pour améliorer continuellement notre système et vous offrir les informations les plus fiables.</p>
            <p>Cependant, notre service ne remplace pas l'avis d'un médecin. Consultez toujours un professionnel de santé pour un diagnostic définitif.</p>
        </div>
    </div>
</div>

<style>
    * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f5f5;
        }
.hero {
    background-color: #f8f9fa;
    padding: 2rem;
    border-radius: 0.3rem;
    margin-bottom: 1rem;
}

.hero h1 {
    font-size: 2.5rem;
    margin-bottom: 1rem;
}

.hero .lead {
    font-size: 1.25rem;
    margin-bottom: 1rem;
}

.hero hr {
    margin: 1.5rem 0;
    border: 0;
    border-top: 1px solid rgba(0,0,0,.1);
}

.btn {
    display: inline-block;
    padding: 0.5rem 1rem;
    background-color: #007bff;
    color: white;
    font-weight: bold;
    margin-top: 1rem;
    text-decoration: none;
    border-radius: 0.25rem;
    transition: background-color 0.3s;
}

.btn:hover {
    background-color: #0056b3;
}

.features {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin-bottom: 1rem;
}

.feature-card {
    flex: 1;
    min-width: 300px;
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.card-content {
    padding: 1.5rem;
    text-align: center;
}

.card-content i {
    font-size: 2.5rem;
    color: #007bff;
    margin-bottom: 1rem;
}

.card-content h5 {
    margin-bottom: 1rem;
}

.info-sections {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
}

.info-card {
    flex: 1;
    min-width: 300px;
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.card-header {
    background-color: #007bff;
    color: white;
    padding: 1rem;
    border-radius: 0.3rem 0.3rem 0 0;
}

.card-header h5 {
    margin: 0;
}

.card-body {
    padding: 1.5rem;
}

.card-body ol {
    padding-left: 1.5rem;
    margin: 0;
}

.card-body li {
    margin-bottom: 0.5rem;
}

@media (max-width: 768px) {
    .features, .info-sections {
        flex-direction: column;
    }
    
    .feature-card, .info-card {
        width: 100%;
    }
}
</style> 

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Gestion des dropdown menus dans la navbar
    const navbarDropdown = document.getElementById('navbarDropdown');
    const userDropdown = document.getElementById('userDropdown');
    
    if (navbarDropdown && userDropdown) {
        // Afficher/masquer le dropdown au clic
        navbarDropdown.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            userDropdown.classList.toggle('show');
        });
        
        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            if (!navbarDropdown.contains(e.target) && !userDropdown.contains(e.target)) {
                userDropdown.classList.remove('show');
            }
        });
    }
});
</script> 