<div class="faq-container">
    <div class="faq-card">
        <div class="card-header">
            <h4><i class="fas fa-question-circle"></i>Foire aux questions</h4>
        </div>
        <div class="card-body">
            <p>Vous trouverez ci-dessous les réponses aux questions les plus fréquemment posées sur notre système de diagnostic médical. Si vous ne trouvez pas la réponse à votre question, n'hésitez pas à nous contacter.</p>
            
            <div class="faq-section">
                <h5>Généralités</h5>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Qu'est-ce que <?= APP_NAME ?> ?
                    </button>
                    <div class="faq-answer">
                        <?= APP_NAME ?> est un système de diagnostic médical en ligne qui analyse vos symptômes et vous aide à identifier les maladies potentielles. Notre système utilise une base de données complète et des algorithmes avancés pour fournir des informations précises et pertinentes.
                    </div>
                </div>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Comment fonctionne le système de diagnostic ?
                    </button>
                    <div class="faq-answer">
                        Notre système fonctionne en analysant les symptômes que vous sélectionnez et en les comparant à notre base de données de maladies. Nous utilisons des algorithmes d'apprentissage automatique et des statistiques médicales pour identifier les maladies les plus probables en fonction de vos symptômes.
                    </div>
                </div>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Le service est-il gratuit ?
                    </button>
                    <div class="faq-answer">
                        Oui, notre service de base est entièrement gratuit. Nous proposons également des fonctionnalités premium pour les utilisateurs qui souhaitent des analyses plus détaillées et des recommandations personnalisées.
                    </div>
                </div>
            </div>
            
            <div class="faq-section">
                <h5>Diagnostic</h5>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Les résultats du diagnostic sont-ils fiables ?
                    </button>
                    <div class="faq-answer">
                        Notre système fournit des informations basées sur les symptômes que vous indiquez et notre base de données médicale. Cependant, il est important de noter que notre service ne remplace pas l'avis d'un médecin. Nous vous recommandons toujours de consulter un professionnel de la santé pour un diagnostic définitif.
                    </div>
                </div>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Combien de symptômes dois-je sélectionner pour obtenir un résultat précis ?
                    </button>
                    <div class="faq-answer">
                        Il est recommandé de sélectionner tous les symptômes que vous ressentez pour obtenir les résultats les plus précis. Plus vous fournissez d'informations, plus notre système peut affiner son analyse. Cependant, même avec un petit nombre de symptômes, notre système peut fournir des informations utiles.
                    </div>
                </div>
            </div>
            
            <div class="faq-section">
                <h5>Confidentialité</h5>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Comment mes données sont-elles protégées ?
                    </button>
                    <div class="faq-answer">
                        Nous prenons la sécurité et la confidentialité de vos données très au sérieux. Toutes les informations que vous partagez avec nous sont cryptées et stockées en toute sécurité. Nous ne partageons jamais vos données personnelles avec des tiers sans votre consentement explicite.
                    </div>
                </div>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Puis-je supprimer mon compte et mes données ?
                    </button>
                    <div class="faq-answer">
                        Oui, vous pouvez supprimer votre compte et toutes vos données à tout moment depuis les paramètres de votre compte. Une fois supprimées, vos données ne peuvent pas être récupérées.
                    </div>
                </div>
            </div>
            
            <div class="faq-section">
                <h5>Support</h5>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Comment puis-je contacter le support technique ?
                    </button>
                    <div class="faq-answer">
                        Vous pouvez contacter notre équipe de support technique en utilisant le formulaire de contact sur notre site web, ou en envoyant un email à support@diagnostic-medical.com. Nous nous efforçons de répondre à toutes les demandes dans un délai de 24 heures.
                    </div>
                </div>
                
                <div class="faq-item">
                    <button class="faq-question" onclick="toggleFaq(this)">
                        Comment puis-je signaler un problème ou suggérer une amélioration ?
                    </button>
                    <div class="faq-answer">
                        Nous sommes toujours à l'écoute de vos retours. Vous pouvez signaler un problème ou suggérer une amélioration en utilisant notre formulaire de contact ou en envoyant un email à feedback@diagnostic-medical.com. Vos retours sont essentiels pour améliorer notre service.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="contact-prompt">
    <div class="contact-card">
        <div class="card-header">
            <h5><i class="fas fa-envelope"></i>Vous n'avez pas trouvé votre réponse ?</h5>
        </div>
        <div class="card-body">
            <p>Si vous n'avez pas trouvé la réponse à votre question, n'hésitez pas à nous contacter. Notre équipe se fera un plaisir de vous aider.</p>
            <a href="<?= APP_URL ?>/contact" class="contact-btn">
                <i class="fas fa-envelope"></i>Nous contacter
            </a>
        </div>
    </div>
</div>

<style>
.faq-container, .contact-prompt {
    margin-bottom: 2rem;
}

.faq-card, .contact-card {
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.card-header {
    background-color: #007bff;
    color: white;
    padding: 1rem;
    border-radius: 0.3rem 0.3rem 0 0;
}

.card-header h4, .card-header h5 {
    margin: 0;
}

.card-body {
    padding: 1.5rem;
}

.faq-section h5 {
    border-bottom: 1px solid #dee2e6;
    padding-bottom: 0.5rem;
    margin: 2rem 0 1rem;
}

.faq-item {
    margin-bottom: 1rem;
}

.faq-question {
    width: 100%;
    text-align: left;
    padding: 1rem;
    background-color: #f8f9fa;
    border: none;
    border-radius: 0.25rem;
    cursor: pointer;
    transition: background-color 0.3s;
}

.faq-question:hover {
    background-color: #e9ecef;
}

.faq-answer {
    display: none;
    padding: 1rem;
    background-color: white;
    border: 1px solid #dee2e6;
    border-top: none;
    border-radius: 0 0 0.25rem 0.25rem;
}

.faq-answer.active {
    display: block;
}

.contact-btn {
    display: inline-block;
    padding: 0.75rem 1.5rem;
    background-color: #007bff;
    color: white;
    text-decoration: none;
    border-radius: 0.25rem;
    transition: background-color 0.3s;
}

.contact-btn:hover {
    background-color: #0056b3;
}

@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }
}
</style>

<script>
function toggleFaq(button) {
    const answer = button.nextElementSibling;
    const isActive = answer.classList.contains('active');
    
    // Fermer toutes les autres réponses
    document.querySelectorAll('.faq-answer').forEach(item => {
        item.classList.remove('active');
    });
    
    // Ouvrir/fermer la réponse cliquée
    if (!isActive) {
        answer.classList.add('active');
    }
}
</script> 