<div class="contact-container">
    <div class="contact-form-card">
        <div class="card-header">
            <h4><i class="fas fa-envelope"></i>Contactez-nous</h4>
        </div>
        <div class="card-body">
            <p>Nous sommes à votre écoute ! Utilisez le formulaire ci-dessous pour nous envoyer un message.</p>
            
            <form action="<?= APP_URL ?>/public/contact" method="POST" class="contact-form">
                <div class="form-row">
                    <div class="form-group">
                        <label for="name">Nom complet</label>
                        <input type="text" id="name" name="name" required placeholder="Votre nom complet">
                    </div>
                    <div class="form-group">
                        <label for="email">Adresse email</label>
                        <input type="email" id="email" name="email" required placeholder="Votre adresse email">
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="subject">Sujet</label>
                    <input type="text" id="subject" name="subject" required placeholder="Le sujet de votre message">
                </div>
                
                <div class="form-group">
                    <label for="message">Message</label>
                    <textarea id="message" name="message" rows="5" required placeholder="Votre message"></textarea>
                </div>
                
                <div class="form-check">
                    <input type="checkbox" id="privacy" name="privacy" required>
                    <label for="privacy">J'accepte que mes données soient traitées conformément à la <a href="#">politique de confidentialité</a></label>
                </div>
                
                <div class="form-submit">
                    <button type="submit">
                        <i class="fas fa-paper-plane"></i>Envoyer le message
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="contact-info-container">
    <div class="contact-info-grid">
        <div class="contact-info-card">
            <div class="info-icon">
                <i class="fas fa-map-marker-alt"></i>
            </div>
            <h5>Adresse</h5>
            <p>123 Rue de la Santé<br>75000 Paris<br>France</p>
        </div>
        <div class="contact-info-card">
            <div class="info-icon">
                <i class="fas fa-phone"></i>
            </div>
            <h5>Téléphone</h5>
            <p>+33 1 23 45 67 89<br>Lundi-Vendredi, 9h-18h</p>
        </div>
        <div class="contact-info-card">
            <div class="info-icon">
                <i class="fas fa-envelope"></i>
            </div>
            <h5>Email</h5>
            <p>contact@diagnostic-medical.com<br>support@diagnostic-medical.com</p>
        </div>
    </div>
</div>

<div class="map-container">
    <div class="map-card">
        <div class="card-body">
            <h5>Notre emplacement</h5>
            <div class="map-wrapper">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2624.9916256937595!2d2.292292615509126!3d48.85837007928757!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e66e2964e34e2d%3A0x8ddca9ee380ef7e0!2sTour%20Eiffel!5e0!3m2!1sfr!2sfr!4v1649351012321!5m2!1sfr!2sfr" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </div>
</div>

<style>
.contact-container, .contact-info-container, .map-container {
    margin-bottom: 2rem;
}

.contact-form-card, .map-card {
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.card-header {
    background-color: #007bff;
    color: white;
    padding: 1rem;
    border-radius: 0.3rem 0.3rem 0 0;
}

.card-header h4 {
    margin: 0;
}

.card-body {
    padding: 1.5rem;
}

.contact-form {
    max-width: 800px;
    margin: 0 auto;
}

.form-row {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.form-group {
    flex: 1;
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
}

.form-group input,
.form-group textarea {
    width: 100%;
    padding: 0.75rem;
    border: 1px solid #ced4da;
    border-radius: 0.25rem;
    transition: border-color 0.3s;
}

.form-group input:focus,
.form-group textarea:focus {
    border-color: #80bdff;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}

.form-check {
    display: flex;
    align-items: center;
    margin-bottom: 1.5rem;
}

.form-check input {
    margin-right: 0.5rem;
}

.form-check a {
    color: #007bff;
    text-decoration: none;
}

.form-check a:hover {
    text-decoration: underline;
}

.form-submit {
    margin-top: 1.5rem;
}

.form-submit button {
    width: 100%;
    padding: 0.75rem;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 0.25rem;
    cursor: pointer;
    transition: background-color 0.3s;
}

.form-submit button:hover {
    background-color: #0056b3;
}

.contact-info-grid {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
}

.contact-info-card {
    flex: 1;
    min-width: 250px;
    text-align: center;
    padding: 1.5rem;
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.info-icon {
    font-size: 2rem;
    color: #007bff;
    margin-bottom: 1rem;
}

.contact-info-card h5 {
    margin-bottom: 1rem;
}

.contact-info-card p {
    margin: 0;
    color: #6c757d;
}

.map-wrapper {
    position: relative;
    padding-bottom: 56.25%;
    height: 0;
    overflow: hidden;
}

.map-wrapper iframe {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border: none;
}

@media (max-width: 768px) {
    .form-row {
        flex-direction: column;
        gap: 0;
    }
    
    .contact-info-grid {
        flex-direction: column;
    }
    
    .contact-info-card {
        width: 100%;
    }
}
</style> 