<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nouveau diagnostic</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #007bff;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --info-color: #17a2b8;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f5f5;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            overflow: hidden;
        }

        .card-header {
            background-color: var(--primary-color);
            color: white;
            padding: 15px 20px;
            display: flex;
            align-items: center;
        }

        .card-header h4 {
            margin: 0;
            font-size: 1.25rem;
        }

        .card-header i {
            margin-right: 10px;
        }

        .card-body {
            padding: 20px;
        }

        .card-text {
            margin-bottom: 15px;
            color: var(--secondary-color);
        }

        .text-danger {
            color: var(--danger-color);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }

        .input-group {
            display: flex;
            margin-bottom: 15px;
        }

        .input-group-text {
            background-color: var(--light-color);
            border: 1px solid #ced4da;
            border-right: none;
            padding: 8px 12px;
            border-radius: 4px 0 0 4px;
        }

        .form-control {
            flex: 1;
            padding: 8px 12px;
            border: 1px solid #ced4da;
            border-radius: 0 4px 4px 0;
            font-size: 1rem;
        }

        .symptom-list {
            border: 1px solid #ced4da;
            border-radius: 4px;
            padding: 15px;
            max-height: 300px;
            overflow-y: auto;
        }

        .symptom-category {
            margin: 15px 0 8px;
            font-weight: 600;
            color: var(--dark-color);
        }

        .symptom-item {
            margin-bottom: 8px;
        }

        .form-check {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
        }

        .form-check-input {
            margin-right: 8px;
        }

        .selected-symptoms {
            margin-top: 15px;
        }

        .selected-symptoms h6 {
            margin-bottom: 10px;
            color: var(--dark-color);
        }

        .selected-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        .badge {
            background-color: var(--primary-color);
            color: white;
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 0.875rem;
            display: inline-flex;
            align-items: center;
        }

        .badge i {
            margin-left: 5px;
            cursor: pointer;
        }

        .btn {
            display: inline-block;
            padding: 10px 20px;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1rem;
            text-align: center;
            text-decoration: none;
            transition: background-color 0.3s;
        }

        .btn:hover {
            background-color: #0056b3;
        }

        .btn i {
            margin-right: 5px;
        }

        .text-muted {
            color: var(--secondary-color);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header">
                <i class="fas fa-stethoscope"></i>
                <h4>Nouveau diagnostic</h4>
            </div>
            <div class="card-body">
                <p class="card-text">Sélectionnez les symptômes que vous ressentez pour obtenir un diagnostic préliminaire.</p>
                <p class="text-danger"><strong>Note:</strong> Ce système n'est pas un substitut à une consultation médicale professionnelle. Consultez toujours un médecin pour un diagnostic définitif.</p>
                
                <form action="<?= APP_URL ?>/diagnostic/analyze" method="POST" id="symptomForm">
                    <div class="form-group">
                        <label for="symptomSelect" class="form-label">Rechercher et sélectionner vos symptômes:</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-search"></i></span>
                            <input type="text" class="form-control" id="symptomSearch" placeholder="Rechercher des symptômes...">
                        </div>
                        
                        <div class="symptom-list">
                            <?php foreach ($symptoms as $category => $categorySymptoms): ?>
                                <h6 class='symptom-category'><?= $category ?></h6>
                                <?php foreach ($categorySymptoms as $symptom): ?>
                                    <div class='form-check symptom-item'>
                                        <input class='form-check-input' type='checkbox' name='symptoms[]' value='<?= $symptom['id'] ?>' id='symptom<?= $symptom['id'] ?>'>
                                        <label class='form-check-label' for='symptom<?= $symptom['id'] ?>'><?= $symptom['name'] ?></label>
                                    </div>
                                <?php endforeach; ?>
                            <?php endforeach; ?>
                        </div>
                        
                        <div class="selected-symptoms">
                            <h6>Symptômes sélectionnés:</h6>
                            <div class="selected-tags">
                                <p class="text-muted" id="noSymptomsSelected">Aucun symptôme sélectionné</p>
                            </div>
                        </div>
                    </div>
                    
                    <input type="hidden" name="symptoms" id="symptomsInput">
                    
                    <button type="submit" class="btn">
                        <i class="fas fa-search-plus"></i>Analyser les symptômes
                        </button>
                </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const symptomSearch = document.getElementById('symptomSearch');
    const symptomCategories = document.querySelectorAll('.symptom-category');
    const symptomItems = document.querySelectorAll('.symptom-item');
    const noSymptomsSelected = document.getElementById('noSymptomsSelected');
    const symptomsInput = document.getElementById('symptomsInput');
    const selectedTags = document.querySelector('.selected-tags');
    const form = document.getElementById('symptomForm');
    
    // Fonction de recherche améliorée
    symptomSearch.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase().trim();
        
        // Réinitialiser l'affichage de toutes les catégories
        symptomCategories.forEach(category => {
            category.style.display = 'none';
        });
        
        // Compter les symptômes visibles par catégorie
        const visibleByCategory = {};
        
        symptomItems.forEach(item => {
            const text = item.textContent.toLowerCase();
            const checkbox = item.querySelector('input[type="checkbox"]');
            const categoryHeader = item.previousElementSibling;
            let categoryName = '';
            
            // Trouver la catégorie parente
            let element = item;
            while (element) {
                if (element.previousElementSibling && element.previousElementSibling.classList.contains('symptom-category')) {
                    categoryName = element.previousElementSibling.textContent;
                    break;
                }
                element = element.previousElementSibling;
            }
            
            // Déterminer si l'élément doit être affiché
            if (searchTerm === '' || text.includes(searchTerm)) {
                item.style.display = 'flex';
                
                // Incrémenter le compteur pour cette catégorie
                if (!visibleByCategory[categoryName]) {
                    visibleByCategory[categoryName] = 0;
                }
                visibleByCategory[categoryName]++;
            } else {
                // Ne pas masquer si le symptôme est sélectionné
                if (checkbox && checkbox.checked) {
                    item.style.display = 'flex';
                    
                    // Incrémenter le compteur pour cette catégorie
                    if (!visibleByCategory[categoryName]) {
                        visibleByCategory[categoryName] = 0;
                    }
                    visibleByCategory[categoryName]++;
            } else {
                item.style.display = 'none';
                }
            }
        });
        
        // Afficher uniquement les catégories qui ont des symptômes visibles
        symptomCategories.forEach(category => {
            const categoryName = category.textContent;
            if (visibleByCategory[categoryName] && visibleByCategory[categoryName] > 0) {
                category.style.display = 'block';
            }
        });
    });
    
    // Mise à jour des symptômes sélectionnés
    document.querySelectorAll('input[name="symptoms[]"]').forEach(checkbox => {
        checkbox.addEventListener('change', updateSelectedSymptoms);
    });
    
    function updateSelectedSymptoms() {
        const checked = document.querySelectorAll('input[name="symptoms[]"]:checked');
        const selectedIds = Array.from(checked).map(input => input.value);
        
        symptomsInput.value = selectedIds.join(',');
        
        if (checked.length === 0) {
            selectedTags.innerHTML = '<p class="text-muted" id="noSymptomsSelected">Aucun symptôme sélectionné</p>';
        } else {
            let tagsHTML = '';
            checked.forEach(input => {
                const label = input.nextElementSibling.textContent;
                tagsHTML += `<span class="badge">${label} <i class="fas fa-times-circle" data-id="${input.value}"></i></span>`;
            });
            
            selectedTags.innerHTML = tagsHTML;
            
            document.querySelectorAll('.selected-tags .badge i').forEach(icon => {
                icon.addEventListener('click', function() {
                    const id = this.getAttribute('data-id');
                    document.getElementById('symptom' + id).checked = false;
                    updateSelectedSymptoms();
                    
                    // Relancer la recherche pour mettre à jour l'affichage
                    const event = new Event('input');
                    symptomSearch.dispatchEvent(event);
                });
            });
        }
        
        // Relancer la recherche pour mettre à jour l'affichage après changement de sélection
        const event = new Event('input');
        symptomSearch.dispatchEvent(event);
    }
    
    // Initialiser les symptômes sélectionnés au chargement
    updateSelectedSymptoms();
    
    form.addEventListener('submit', function(e) {
        const checked = document.querySelectorAll('input[name="symptoms[]"]:checked');
        if (checked.length === 0) {
            e.preventDefault();
            alert('Veuillez sélectionner au moins un symptôme.');
        }
    });
    
    // Gestion des dropdown menus dans la navbar
    const navbarDropdown = document.getElementById('navbarDropdown');
    const userDropdown = document.getElementById('userDropdown');
    
    if (navbarDropdown && userDropdown) {
        // Afficher/masquer le dropdown au clic
        navbarDropdown.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            userDropdown.classList.toggle('show');
        });
        
        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            if (!navbarDropdown.contains(e.target) && !userDropdown.contains(e.target)) {
                userDropdown.classList.remove('show');
            }
        });
    }
});
</script> 
</body>
</html> 