<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inscription - <?= APP_NAME ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="register-container">
        <h3 class="register-title">Inscription</h3>

        <?php if (isset($_SESSION['errors'])): ?>
            <div class="alert alert-danger">
                <?php foreach ($_SESSION['errors'] as $error): ?>
                    <p><?= $error ?></p>
                <?php endforeach; ?>
                <?php unset($_SESSION['errors']); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger">
                <p><?= $_SESSION['error'] ?></p>
                <?php unset($_SESSION['error']); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success">
                <p><?= $_SESSION['success'] ?></p>
                <?php unset($_SESSION['success']); ?>
            </div>
        <?php endif; ?>

        <form action="<?= APP_URL ?>/auth/register" method="POST" class="register-form">
            <div class="form-group">
                <label for="first_name">Prénom</label>
                <div class="input-group">
                    <span class="input-icon"><i class="fas fa-user"></i></span>
                    <input type="text" id="first_name" name="first_name" required 
                           placeholder="Votre prénom" 
                           value="<?= isset($_SESSION['form_data']['first_name']) ? htmlspecialchars($_SESSION['form_data']['first_name']) : '' ?>">
                </div>
            </div>
            <div class="form-group">
                <label for="last_name">Nom</label>
                <div class="input-group">
                    <span class="input-icon"><i class="fas fa-user"></i></span>
                    <input type="text" id="last_name" name="last_name" required 
                           placeholder="Votre nom"
                           value="<?= isset($_SESSION['form_data']['last_name']) ? htmlspecialchars($_SESSION['form_data']['last_name']) : '' ?>">
                </div>
            </div>
            <div class="form-group">
                <label for="email">Adresse email</label>
                <div class="input-group">
                    <span class="input-icon"><i class="fas fa-envelope"></i></span>
                    <input type="email" id="email" name="email" required 
                           placeholder="Votre adresse email"
                           value="<?= isset($_SESSION['form_data']['email']) ? htmlspecialchars($_SESSION['form_data']['email']) : '' ?>">
                </div>
            </div>
            <div class="form-group">
                <label for="password">Mot de passe</label>
                <div class="input-group">
                    <span class="input-icon"><i class="fas fa-lock"></i></span>
                    <input type="password" id="password" name="password" required placeholder="Votre mot de passe">
                    <button type="button" class="toggle-btn" data-target="password" >
                                        <i class="fas fa-eye"></i>
                                    </button>
                </div>
                <div class="form-text">Le mot de passe doit contenir au moins 8 caractères, incluant des lettres, des chiffres et des caractères spéciaux.</div>
            </div>
            <div class="form-group">
                <label for="confirm_password">Confirmer le mot de passe</label>
                <div class="input-group">
                    <span class="input-icon"><i class="fas fa-lock"></i></span>
                    <input type="password" id="confirm_password" name="confirm_password" required placeholder="Confirmez votre mot de passe">
                    <button type="button" class="toggle-btn" data-target="confirm_password" >
                                        <i class="fas fa-eye"></i>
                                    </button>
                </div>
            </div>
            <div class="form-check">
                <input type="checkbox" id="terms" name="terms" required>
                <label for="terms">J'accepte les <a href="#">conditions d'utilisation</a> et la <a href="#">politique de confidentialité</a></label>
            </div>
            <div class="form-submit">
                <button type="submit">
                    <i class="fas fa-user-plus"></i>S'inscrire
                </button>
            </div>
        </form>

        <div class="register-footer">
            <p>Vous avez déjà un compte ? <a href="<?= APP_URL ?>/auth/login">Connectez-vous</a></p>
        </div>
    </div>

<style>
.register-container {
    max-width: 500px;
    margin: 2rem auto;
    padding: 0 1rem;
}

.alert {
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 4px;
}

.alert-danger {
    background-color: #f8d7da;
    border: 1px solid #f5c6cb;
    color: #721c24;
}

.alert-success {
    background-color: #d4edda;
    border: 1px solid #c3e6cb;
    color: #155724;
}

.alert p {
    margin: 0.5rem 0;
}

.register-title {
    text-align: center;
    margin-bottom: 2rem;
}

.register-form {
    max-width: 400px;
    margin: 0 auto;
    padding: 2rem;
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
}

.input-group {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon {
    position: absolute;
    left: 0.75rem;
    color: #6c757d;
}

.input-group input {
    width: 100%;
    padding: 0.75rem 0.75rem 0.75rem 2.5rem;
    border: 1px solid #ced4da;
    border-radius: 0.25rem;
    transition: border-color 0.3s;
}

.input-group input:focus {
    border-color: #80bdff;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}

.toggle-btn {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            color: var(--text-color);
        }
.fas{
    font-size: 1rem;
    margin-right: 0.5rem;
    color: #6c757d;
}
.form-text {
    margin-top: 0.5rem;
    font-size: 0.875rem;
    color: #6c757d;
}

.form-check {
    display: flex;
    align-items: center;
    margin-bottom: 1.5rem;
}

.form-check input {
    margin-right: 0.5rem;
}

.form-check a {
    color: #007bff;
    text-decoration: none;
}

.form-check a:hover {
    text-decoration: underline;
}

.form-submit {
    margin-top: 1.5rem;
}

.form-submit button {
    width: 100%;
    padding: 0.75rem;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 0.25rem;
    cursor: pointer;
    transition: background-color 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
}

.form-submit button:hover {
    background-color: #0056b3;
}

.register-footer {
    text-align: center;
    margin-top: 1.5rem;
}

.register-footer a {
    color: #007bff;
    text-decoration: none;
}

.register-footer a:hover {
    text-decoration: underline;
}
</style>

<script>
    // Afficher/masquer les mots de passe
    const toggleButtons = document.querySelectorAll('.toggle-btn');
    toggleButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetId = this.getAttribute('data-target');
            const input = document.getElementById(targetId);
            const icon = this.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.className = 'fas fa-eye-slash';
            } else {
                input.type = 'password';
                icon.className = 'fas fa-eye';
            }

        });
    });
</script>
</body>
</html> 