<h3 class="login-title">Connexion</h3>

<form action="<?= APP_URL ?>/auth/login" method="POST" class="login-form">
    <div class="form-group">
        <label for="email">Adresse email</label>
        <div class="input-group">
            <span class="input-icon"><i class="fas fa-envelope"></i></span>
            <input type="email" id="email" name="email" required placeholder="Votre adresse email">
        </div>
    </div>
    <div class="form-group">
        <label for="password">Mot de passe</label>
        <div class="input-group">
            <span class="input-icon"><i class="fas fa-lock"></i></span>
            <input type="password" id="password" name="password" required placeholder="Votre mot de passe">
            <button type="button" class="toggle-btn" data-target="password" >
                                        <i class="fas fa-eye"></i>
                                    </button>
        </div>
    </div>
    <div class="form-check">
        <input type="checkbox" id="remember" name="remember">
        <label for="remember">Se souvenir de moi</label>
    </div>
    <div class="form-submit">
        <button type="submit">
            <i class="fas fa-sign-in-alt"></i>Se connecter
        </button>
    </div>
</form>

<div class="login-footer">
    <p>Vous n'avez pas de compte ? <a href="<?= APP_URL ?>/auth/register">Inscrivez-vous</a></p>
</div>

<style>
.login-title {
    text-align: center;
    margin-bottom: 2rem;
}

.login-form {
    max-width: 400px;
    margin: 0 auto;
    padding: 2rem;
    background: white;
    border-radius: 0.3rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    margin-bottom: 0.5rem;/
    font-weight: 500;
}

.toggle-btn {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            color: var(--text-color);
        }
.fas{
    font-size: 1rem;
    margin-right: 0.5rem;
    color: #6c757d;
}
.input-group {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon {
    position: absolute;
    left: 0.75rem;
    color: #6c757d;
}

.input-group input {
    width: 100%;
    padding: 0.75rem 0.75rem 0.75rem 2.5rem;
    border: 1px solid #ced4da;
    border-radius: 0.25rem;
    transition: border-color 0.3s;
}


.input-group input:focus {
    border-color: #80bdff;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}

.form-check {
    display: flex;
    align-items: center;
    margin-bottom: 1.5rem;
}

.form-check input {
    margin-right: 0.5rem;
}

.form-submit {
    margin-top: 1.5rem;
}

.form-submit button {
    width: 100%;
    padding: 0.75rem;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 0.25rem;
    cursor: pointer;
    transition: background-color 0.3s;
}

.form-submit button:hover {
    background-color: #0056b3;
}

.login-footer {
    text-align: center;
    margin-top: 1.5rem;
}

.login-footer a {
    color: #007bff;
    text-decoration: none;
}

.login-footer a:hover {
    text-decoration: underline;
}
</style> 

<script>
 // Afficher/masquer les mots de passe
 const toggleButtons = document.querySelectorAll('.toggle-btn');
            toggleButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetId = this.getAttribute('data-target');
                    const input = document.getElementById(targetId);
                    const icon = this.querySelector('i');
                    
                    if (input.type === 'password') {
                        input.type = 'text';
                        icon.className = 'fas fa-eye-slash';
                    } else {
                        input.type = 'password';
                        icon.className = 'fas fa-eye';
                    }
                });
            });

</script>
