<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestion des maladies</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #007bff;
            --danger-color: #dc3545;
            --success-color: #28a745;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
            --border-color: #ced4da;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f5f5;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .grid {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 20px;
            align-items: start;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            height: fit-content;
        }

        .card-header {
            background-color: var(--primary-color);
            color: white;
            padding: 15px 20px;
            border-radius: 8px 8px 0 0;
            display: flex;
            align-items: center;
        }

        .card-header h5 {
            margin: 0;
            font-size: 1.1em;
        }

        .card-header i {
            margin-right: 10px;
        }

        .card-body {
            padding: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }

        .form-control {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(0,123,255,0.25);
        }

        textarea.form-control {
            min-height: 100px;
            resize: vertical;
        }

        .search-container {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .search-input {
            flex: 1;
            padding: 8px 12px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 1rem;
        }

        .search-icon {
            margin-left: -30px;
            color: #6c757d;
        }

        .table-container {
            overflow-x: auto;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .table th,
        .table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        .table th {
            background-color: var(--light-color);
            font-weight: 600;
        }

        .table tr:hover {
            background-color: rgba(0,0,0,0.02);
        }

        .btn {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            font-size: 0.9rem;
            text-decoration: none;
            transition: background-color 0.3s;
        }

        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }

        .btn-primary:hover {
            background-color: #0056b3;
        }

        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }

        .btn-danger:hover {
            background-color: #c82333;
        }

        .btn-success {
            background-color: var(--success-color);
            color: white;
        }

        .btn-success:hover {
            background-color: #218838;
        }

        .btn-group {
            display: flex;
            gap: 5px;
        }

        .btn-group .btn {
            padding: 4px 8px;
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }

        .modal.show {
            display: flex;
        }

        .modal-dialog {
            margin: 0 auto;
            max-width: 500px;
            width: 100%;
        }

        .modal-content {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .modal-header {
            padding: 15px 20px;
            border-bottom: 1px solid #eee;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .modal-body {
            padding: 20px;
        }

        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid #eee;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        .btn-close {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: #666;
        }

        .text-danger {
            color: var(--danger-color);
        }

        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
        }

        .toast {
            padding: 15px 20px;
            border-radius: 4px;
            margin-bottom: 10px;
            color: white;
            display: flex;
            align-items: center;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            animation: slideIn 0.3s ease-out forwards, fadeOut 0.5s ease-out 4.5s forwards;
            max-width: 350px;
        }

        .toast i {
            margin-right: 10px;
            font-size: 1.2rem;
        }

        .toast-success {
            background-color: var(--success-color);
        }

        .toast-error {
            background-color: var(--danger-color);
        }

        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        @keyframes fadeOut {
            from { opacity: 1; }
            to { opacity: 0; visibility: hidden; }
        }

        @media (max-width: 768px) {
            .grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="grid">
        <div class="card">
                <div class="card-header">
                    <i class="fas fa-plus-circle"></i>
                    <h5>Ajouter une maladie</h5>
            </div>
            <div class="card-body">
                    <form action="<?= APP_URL ?>/admin/diseases" method="POST" id="addDiseaseForm">
                    <input type="hidden" name="action" value="add">
                    
                        <div class="form-group">
                        <label for="name" class="form-label">Nom de la maladie</label>
                        <input type="text" class="form-control" id="name" name="name" required placeholder="Ex: Grippe">
                    </div>
                    
                        <div class="form-group">
                        <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" placeholder="Décrivez brièvement la maladie..."></textarea>
                    </div>
                    
                        <div class="form-group">
                        <label for="treatment" class="form-label">Traitement recommandé</label>
                            <textarea class="form-control" id="treatment" name="treatment" placeholder="Décrivez les traitements possibles..."></textarea>
                    </div>
                    
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Enregistrer
                        </button>
                </form>
        </div>
    </div>
    
        <div class="card">
                <div class="card-header">
                    <i class="fas fa-virus"></i>
                    <h5>Liste des maladies</h5>
                </div>
                <div class="card-body">
                    <div class="search-container">
                        <input type="text" id="searchDisease" class="search-input" placeholder="Rechercher une maladie...">
                        <i class="fas fa-search search-icon"></i>
            </div>
                    
                    <div class="table-container">
                        <table class="table">
                        <thead>
                            <tr>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="diseasesTableBody">
                            <?php 
                            usort($diseases, function($a, $b) {
                                return strcasecmp($a['name'], $b['name']);
                            });
                            
                            // Pagination
                            $itemsPerPage = 7;
                            $currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                            $totalItems = count($diseases);
                            $totalPages = ceil($totalItems / $itemsPerPage);
                            
                            // Ensure current page is valid
                            if ($currentPage < 1) $currentPage = 1;
                            if ($currentPage > $totalPages) $currentPage = $totalPages;
                            
                            // Calculate start and end items
                            $start = ($currentPage - 1) * $itemsPerPage;
                            $end = min($start + $itemsPerPage - 1, $totalItems - 1);
                            
                            // Display only items for current page
                            for ($i = $start; $i <= $end; $i++): 
                                $disease = $diseases[$i];
                            ?>
                                <tr>
                                    <td><?= $disease['name'] ?></td>
                                    <td><?= $disease['description'] ?></td>
                                    <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-primary edit-disease" 
                                                    data-id="<?= $disease['id'] ?>" 
                                                    data-name="<?= htmlspecialchars($disease['name']) ?>" 
                                                    data-description="<?= htmlspecialchars($disease['description']) ?>"
                                                    data-treatment="<?= isset($disease['treatment']) ? htmlspecialchars($disease['treatment']) : '' ?>">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                                <button type="button" class="btn btn-danger delete-disease" 
                                                    data-id="<?= $disease['id'] ?>" 
                                                    data-name="<?= htmlspecialchars($disease['name']) ?>">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endfor; ?>
                        </tbody>
                    </table>
                    
                    <!-- Pagination Navigation -->
                    <?php if ($totalPages > 1): ?>
                    <div class="pagination-container" style="display: flex; justify-content: center; margin-top: 20px;">
                        <div class="pagination" style="display: flex; gap: 5px;">
                            <?php if ($currentPage > 1): ?>
                                <a href="?page=1" class="btn btn-primary" style="padding: 5px 10px;">&laquo;</a>
                                <a href="?page=<?= $currentPage - 1 ?>" class="btn btn-primary" style="padding: 5px 10px;">&lsaquo;</a>
                            <?php endif; ?>
                            
                            <?php
                            // Show 2 pages before and after current page
                            $startPage = max(1, $currentPage - 2);
                            $endPage = min($totalPages, $currentPage + 2);
                            
                            // Always show first page
                            if ($startPage > 1) {
                                echo '<a href="?page=1" class="btn btn-primary" style="padding: 5px 10px;">1</a>';
                                if ($startPage > 2) {
                                    echo '<span style="padding: 5px 10px;">...</span>';
                                }
                            }
                            
                            // Display page links
                            for ($i = $startPage; $i <= $endPage; $i++) {
                                if ($i == $currentPage) {
                                    echo '<span class="btn btn-success" style="padding: 5px 10px;">' . $i . '</span>';
                                } else {
                                    echo '<a href="?page=' . $i . '" class="btn btn-primary" style="padding: 5px 10px;">' . $i . '</a>';
                                }
                            }
                            
                            // Always show last page
                            if ($endPage < $totalPages) {
                                if ($endPage < $totalPages - 1) {
                                    echo '<span style="padding: 5px 10px;">...</span>';
                                }
                                echo '<a href="?page=' . $totalPages . '" class="btn btn-primary" style="padding: 5px 10px;">' . $totalPages . '</a>';
                            }
                            ?>
                            
                            <?php if ($currentPage < $totalPages): ?>
                                <a href="?page=<?= $currentPage + 1 ?>" class="btn btn-primary" style="padding: 5px 10px;">&rsaquo;</a>
                                <a href="?page=<?= $totalPages ?>" class="btn btn-primary" style="padding: 5px 10px;">&raquo;</a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="toast-container" id="toastContainer"></div>

    <div class="modal" id="editDiseaseModal">
    <div class="modal-dialog">
        <div class="modal-content">
                <form action="<?= APP_URL ?>/admin/diseases" method="POST" id="editDiseaseForm">
                    <div class="modal-header">
                        <h5>Modifier une maladie</h5>
                        <button type="button" class="btn-close" data-dismiss="modal">&times;</button>
            </div>
                <div class="modal-body">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" id="edit_id" name="id">
                    
                        <div class="form-group">
                        <label for="edit_name" class="form-label">Nom de la maladie</label>
                        <input type="text" class="form-control" id="edit_name" name="name" required>
                    </div>
                    
                        <div class="form-group">
                        <label for="edit_description" class="form-label">Description</label>
                            <textarea class="form-control" id="edit_description" name="description"></textarea>
                    </div>
                    
                        <div class="form-group">
                        <label for="edit_treatment" class="form-label">Traitement recommandé</label>
                            <textarea class="form-control" id="edit_treatment" name="treatment"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-success">Enregistrer les modifications</button>
                </div>
            </form>
        </div>
    </div>
</div>

    <div class="modal" id="deleteDiseaseModal">
    <div class="modal-dialog">
        <div class="modal-content">
                <div class="modal-header">
                    <h5>Supprimer une maladie</h5>
                    <button type="button" class="btn-close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <p>Êtes-vous sûr de vouloir supprimer la maladie <strong id="delete_disease_name"></strong> ?</p>
                <p class="text-danger">Cette action est irréversible.</p>
            </div>
            <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Annuler</button>
                    <form action="<?= APP_URL ?>/admin/diseases" method="POST" class="d-inline" id="deleteDiseaseForm">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" id="delete_id" name="id">
                    <button type="submit" class="btn btn-danger">Supprimer</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {

      // Gestion des dropdown menus dans la navbar
      const navbarDropdown = document.getElementById('navbarDropdown');
    const userDropdown = document.getElementById('userDropdown');
    
    if (navbarDropdown && userDropdown) {
        // Afficher/masquer le dropdown au clic
        navbarDropdown.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            userDropdown.classList.toggle('show');
        });
        
        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            if (!navbarDropdown.contains(e.target) && !userDropdown.contains(e.target)) {
                userDropdown.classList.remove('show');
            }
        });
    }


    // Fonction pour afficher les toasts
    function showToast(message, type) {
        const toastContainer = document.getElementById('toastContainer');
        const toast = document.createElement('div');
        toast.className = `toast toast-${type}`;
        
        let icon = '';
        if (type === 'success') {
            icon = '<i class="fas fa-check-circle"></i>';
        } else if (type === 'error') {
            icon = '<i class="fas fa-exclamation-circle"></i>';
        }
        
        toast.innerHTML = `${icon}${message}`;
        toastContainer.appendChild(toast);
        
        // Supprimer le toast après 5 secondes
        setTimeout(() => {
            if (toast && toast.parentNode) {
                toast.parentNode.removeChild(toast);
            }
        }, 5000);
    }
    
    // Vérifier s'il y a un message dans l'URL (après redirection)
    const urlParams = new URLSearchParams(window.location.search);
    const successMsg = urlParams.get('success');
    const errorMsg = urlParams.get('error');
    
    if (successMsg) {
        showToast(decodeURIComponent(successMsg), 'success');
        // Nettoyer l'URL
        window.history.replaceState({}, document.title, window.location.pathname);
    }
    
    if (errorMsg) {
        showToast(decodeURIComponent(errorMsg), 'error');
        // Nettoyer l'URL
        window.history.replaceState({}, document.title, window.location.pathname);
    }

    // Gestion des événements des modales
    function setupModalEvents() {
        // Nettoyer d'abord tous les événements existants
        const allEditButtons = document.querySelectorAll('.edit-disease');
        const allDeleteButtons = document.querySelectorAll('.delete-disease');
        const allCloseButtons = document.querySelectorAll('[data-dismiss="modal"]');
        const allModals = document.querySelectorAll('.modal');
        
        // Supprimer les anciens gestionnaires (pas nécessaire pour la première initialisation)
        allEditButtons.forEach(btn => {
            // Cloner et remplacer pour supprimer les écouteurs d'événements
            const newBtn = btn.cloneNode(true);
            btn.parentNode.replaceChild(newBtn, btn);
        });
        
        allDeleteButtons.forEach(btn => {
            const newBtn = btn.cloneNode(true);
            btn.parentNode.replaceChild(newBtn, btn);
        });
        
        // Réattacher les événements
        document.querySelectorAll('.edit-disease').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const id = this.getAttribute('data-id');
                const name = this.getAttribute('data-name');
                const description = this.getAttribute('data-description');
                const treatment = this.getAttribute('data-treatment');
                
                document.getElementById('edit_id').value = id;
                document.getElementById('edit_name').value = name;
                document.getElementById('edit_description').value = description;
                document.getElementById('edit_treatment').value = treatment || '';
                
                document.getElementById('editDiseaseModal').classList.add('show');
            });
        });
        
        document.querySelectorAll('.delete-disease').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const id = this.getAttribute('data-id');
                const name = this.getAttribute('data-name');
                
                document.getElementById('delete_id').value = id;
                document.getElementById('delete_disease_name').textContent = name;
                
                document.getElementById('deleteDiseaseModal').classList.add('show');
            });
        });
        
        // Gestionnaires pour fermer les modales
        allCloseButtons.forEach(button => {
            const newBtn = button.cloneNode(true);
            button.parentNode.replaceChild(newBtn, button);
        });
        
        document.querySelectorAll('[data-dismiss="modal"]').forEach(button => {
            button.addEventListener('click', function() {
                const modal = this.closest('.modal');
                if (modal) modal.classList.remove('show');
            });
        });
        
        // Fermer en cliquant à l'extérieur
        allModals.forEach(modal => {
            modal.removeEventListener('click', closeModalOutside);
            modal.addEventListener('click', closeModalOutside);
        });
    }
    
    function closeModalOutside(e) {
        if (e.target === this) {
            this.classList.remove('show');
        }
    }
    
    // Initialiser les événements des modales
    setupModalEvents();

    // Interception du formulaire d'ajout
    const addForm = document.getElementById('addDiseaseForm');
    if (addForm) {
        addForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('<?= APP_URL ?>/admin/diseases', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erreur serveur: ' + response.status);
                }
                return response.text().then(text => {
                    // Tenter de parser en JSON, sinon retourner le texte
                    try {
                        return JSON.parse(text);
                    } catch (e) {
                        // Si la réponse n'est pas du JSON, recharger la page
                        window.location.reload();
                        return { success: false, message: 'La réponse du serveur n\'est pas au format JSON.' };
                    }
                });
            })
            .then(data => {
                if (data.success) {
                    showToast(data.message, 'success');
                    setTimeout(() => {
                        window.location.reload();
                    }, 1000);
                } else {
                    showToast(data.message || 'Une erreur est survenue', 'error');
                }
            })
            .catch(error => {
                showToast('Une erreur s\'est produite: ' + error.message, 'error');
                console.error(error);
                // Recharger la page après un court délai
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            });
        });
    }
    
    // Interception du formulaire de modification
    const editForm = document.getElementById('editDiseaseForm');
    if (editForm) {
        editForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('<?= APP_URL ?>/admin/diseases', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erreur serveur: ' + response.status);
                }
                return response.text().then(text => {
                    try {
                        return JSON.parse(text);
                    } catch (e) {
                        window.location.reload();
                        return { success: false, message: 'La réponse du serveur n\'est pas au format JSON.' };
                    }
                });
            })
            .then(data => {
                if (data.success) {
                    showToast(data.message, 'success');
                    document.getElementById('editDiseaseModal').classList.remove('show');
                    setTimeout(() => {
                        window.location.reload();
                    }, 1000);
                } else {
                    showToast(data.message || 'Une erreur est survenue', 'error');
                }
            })
            .catch(error => {
                showToast('Une erreur s\'est produite: ' + error.message, 'error');
                console.error(error);
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            });
        });
    }
    
    // Interception du formulaire de suppression
    const deleteForm = document.getElementById('deleteDiseaseForm');
    if (deleteForm) {
        deleteForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('<?= APP_URL ?>/admin/diseases', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erreur serveur: ' + response.status);
                }
                return response.text().then(text => {
                    try {
                        return JSON.parse(text);
                    } catch (e) {
                        window.location.reload();
                        return { success: false, message: 'La réponse du serveur n\'est pas au format JSON.' };
                    }
                });
            })
            .then(data => {
                if (data.success) {
                    showToast(data.message, 'success');
                    document.getElementById('deleteDiseaseModal').classList.remove('show');
                    setTimeout(() => {
                        window.location.reload();
                    }, 1000);
                } else {
                    showToast(data.message || 'Une erreur est survenue', 'error');
                }
            })
            .catch(error => {
                showToast('Une erreur s\'est produite: ' + error.message, 'error');
                console.error(error);
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            });
        });
    }

    // Recherche de maladies
    const searchDisease = document.getElementById('searchDisease');
    if (searchDisease) {
    searchDisease.addEventListener('keyup', function() {
        const searchTerm = this.value.toLowerCase();
            const rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(row => {
            const name = row.cells[0].textContent.toLowerCase();
            const description = row.cells[1].textContent.toLowerCase();
            
            if (name.includes(searchTerm) || description.includes(searchTerm)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
    }
});
</script> 
</body>
</html> 