<?php
// Configuration de la base de données
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'diagnostic_medical');

// Configuration de l'application
define('APP_NAME', 'Diagnostic Médical');
define('APP_URL', 'http://localhost/consult');
define('APP_ROOT', dirname(__DIR__)); // Chemin absolu vers le dossier /app
define('ASSETS_URL', APP_URL . '/public/assets'); // URL des ressources statiques

// Configuration des erreurs
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Autoloader pour les modèles et les contrôleurs
spl_autoload_register(function ($class) {
    $paths = [
        APP_ROOT . '/core/' . $class . '.php',
        APP_ROOT . '/models/' . $class . '.php',
        APP_ROOT . '/controllers/' . $class . '.php'
    ];
    
    foreach ($paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            return;
        }
    }
});
